##### Rozdział 2: Zarządzanie danymi -------------------

##### Struktury danych R --------------------

## Wektory -----

# tworzymy wektory z danymi trzech pacjentów
subject_name <- c("John Doe", "Jane Doe", "Steve Graves")
temperature <- c(98.1, 98.6, 101.4)
flu_status <- c(FALSE, FALSE, TRUE)

# dostęp do drugiego elementu w wektorze temperatury ciała
temperature[2]

## przykłady dostępu do elementów w wektorze
# dołączamy elementy z zakresu od 2 do 3
temperature[2:3]

# wyłączamy element 2 za pomocą znaku minusa
temperature[-2]

# używamy wektora, aby wskazać, czy element ma być dołączony
temperature[c(TRUE, TRUE, FALSE)]

# tworzymy wektor logiczny z wyrażenia logicznego
fever <- temperature > 100

# identyfikujemy pacjentów z gorączką (oba polecenia dają identyczne wyniki)
subject_name[fever]
subject_name[temperature > 100]

## Czynniki -----

# dodajemy czynnik określający płeć
gender <- factor(c("MALE", "FEMALE", "MALE"))
gender

# dodajemy czynnik określający grupę krwi
blood <- factor(c("O", "AB", "A"),
                levels = c("A", "B", "AB", "O"))
blood

# dodajemy uporządkowany czynniki
symptoms <- factor(c("SEVERE", "MILD", "MODERATE"),
                   levels = c("MILD", "MODERATE", "SEVERE"),
                   ordered = TRUE)
symptoms

# Sprawdzamy, czy objawy pacjenta są cięższe od umiarkowanych
symptoms > "MODERATE"

## Listy -----

# wyświetlamy informacje o pacjencie
subject_name[1]
temperature[1]
flu_status[1]
gender[1]
blood[1]
symptoms[1]

# tworzymy listę dla pacjenta
subject1 <- list(fullname = subject_name[1], 
                 temperature = temperature[1],
                 flu_status = flu_status[1],
                 gender = gender[1],
                 blood = blood[1],
                 symptoms = symptoms[1])

# wyświetlamy pacjenta
subject1

## metody dostępu do listy

# pobieramy jedną wartość z listy wg pozycji (zwraca podlistę)
subject1[2]

# pobieramy jedną wartość z listy wg pozycji (zwraca wektor liczbowy)
subject1[[2]]

# pobieramy jedną wartość z listy wg nazwy
subject1$temperature

# pobieramy kilka elementów listy przez określenie wektora nazw
subject1[c("temperature", "flu_status")]

## uzyskujemy dostęp do listy tak, jak do wektora
# pobieramy wartości 2 i 3
subject1[2:3]

## Ramki danych -----

# tworzymy ramkę danych z danych dotyczących pacjenta

pt_data <- data.frame(subject_name, temperature,
                      flu_status, gender, blood, symptoms)

# wyświetlamy ramkę danych
pt_data

## dostęp do ramki danych

# pobieramy jedną kolumnę
pt_data$subject_name

# pobieramy kilka kolumn przez określenie wektora nazw
pt_data[c("temperature", "flu_status")]

# jak wyżej, pobieramy kolumny temperature i flu_status
pt_data[2:3]

# dostęp wg wiersza i kolumny
pt_data[1, 2]

# dostęp do kilku wierszy i kilku kolumn za pomocą wektorów
pt_data[c(1, 3), c(2, 4)]

## Pozostawiamy wiersz lub kolumnę pustą, aby pobrać wszystkie wiersze lub kolumny

# kolumna 1, wszystkie wiersze
pt_data[, 1]
# wiersz 1, wszystkie kolumny
pt_data[1, ]
# wszystkie wiersze i wszystkie kolumny
pt_data[ , ]

# poniższe polecenia są równoważne
pt_data[c(1, 3), c("temperature", "gender")]
pt_data[-2, c(-1, -3, -5, -6)]

# tworzymy kolumnę temperatury w skali Celsjusza
pt_data$temp_c <- (pt_data$temperature - 32) * (5 / 9)

# porównanie przed i po
pt_data[c("temperature", "temp_c")]

## Macierze -----

# tworzymy macierz 2x2
m <- matrix(c(1, 2, 3, 4), nrow = 2)
m

# równoważne powyższemu poleceniue
m <- matrix(c(1, 2, 3, 4), ncol = 2)
m

# tworzymy macierz 2x3 
m <- matrix(c(1, 2, 3, 4, 5, 6), nrow = 2)
m

# tworzymy macierz 3x2
m <- matrix(c(1, 2, 3, 4, 5, 6), ncol = 2)
m

# wyodrębnianie wartości z macierzy
m[1, 1]
m[3, 2]

# wyodrębniamy wiersze
m[1, ]

# wyodrębniamy kolumny
m[, 1]

##### Zarządzanie danymi w R ------------

## zapisywanie, wczytywanie i usuwanie struktur danych R

# wyświetlamy wszystkie struktury danych w pamięci
ls()

# usuwamy obiekty m i subject1
rm(m, subject1)
ls()

rm(list=ls())

##### Importowanie i zapisywanie zbiorów danych w plikach CSV ------------

# wczytujemy plik CSV
pt_data <- read.csv("pt_data.csv")

# wczytujemy plik CSV i przekształcamy wszystkie kolumny znakowe w czynniki
pt_data <- read.csv("pt_data.csv", stringsAsFactors = TRUE)

##### Eksplorowanie i rozumienie danych --------------------

## przykład eksploracji danych z wykorzystaniem danych o używanych samochodach
usedcars <- read.csv("usedcars.csv")

# wyświetlamy strukturę danych o używanych samochodach
str(usedcars)

## Eksplorowanie zmiennych liczbowych -----

# podsumowujemy zmienne	liczbowe
summary(usedcars$year)
summary(usedcars[c("price", "mileage")])

# obliczamy średni przychód
(36000 + 44000 + 56000) / 3
mean(c(36000, 44000, 56000))

# mediana przychodu
median(c(36000, 44000, 56000))

# minimalna/maksymalna cena używanego samochodu
range(usedcars$price)

# różnica zakresu
diff(range(usedcars$price))

# IQR cen używanych samochodów
IQR(usedcars$price)

# używamy funkcji quantile do obliczenia podsumowania pięcioliczbowego
quantile(usedcars$price)

# 99. percentyl
quantile(usedcars$price, probs = c(0.01, 0.99))

# kwintyle
quantile(usedcars$price, seq(from = 0, to = 1, by = 0.20))

# wykres skrzynkowy cen i przebiegu używanych samochodów
boxplot(usedcars$price, main = "Wykres skrzynkowy cen używanych samochodów",
      ylab = "Cena (USD)")

boxplot(usedcars$mileage, main="Wykres skrzynkowy przebiegu używanych samochodów",
      ylab = "Drogomierz (mile)")

# histogramy cen i przebiegu używanych samochodów
hist(usedcars$price, main = "Histogram cen używanych samochodów",
     xlab = "Cena (USD)")

hist(usedcars$mileage, main = "Histogram przebiegu używanych samochodów",
     xlab = "Drogomierz (mile)")

# wariancja i odchylenie standardowe danych o używanych samochodach
var(usedcars$price)
sd(usedcars$price)
var(usedcars$mileage)
sd(usedcars$mileage)

## Eksplorowanie zmiennych liczbowych -----

# tabele jednodzielcze dla danych o używanych samochodach
table(usedcars$year)
table(usedcars$model)
table(usedcars$color)

# obliczamy proporcje tabeli
model_table <- table(usedcars$model)
prop.table(model_table)

# zaokrąglamy dane
color_table <- table(usedcars$color)
color_pct <- prop.table(color_table) * 100
round(color_pct, digits = 1)

## Eksplorowanie zależności między zmiennymi -----

# wykres skrzynkowy - cena a przebieg
plot(x = usedcars$mileage, y = usedcars$price,
     main = "Wykres punktowy: cena a przebieg",
     xlab = "Drogomierz (mile)",
     ylab = "Cena (dolary)")

# nowa zmienna wskazująca konserwatywne kolory
usedcars$conservative <-
  usedcars$color %in% c("Black", "Gray", "Silver", "White")

# sprawdzamy naszą zmienną
table(usedcars$conservative)

# tabela krzyżowa kolorów konserwatywnych wg modelu
library(gmodels)
CrossTable(x = usedcars$model, y = usedcars$conservative)

# ręczne obliczanie testu chi kwadrat
# etap 1: sumujemy wkłady komórek
0.009 + 0.004 + 0.086 + 0.044 + 0.007 + 0.004

# etap 2: obliczamy prawdopodobieństwo chi kwadrat
pchisq(0.154, df = 2, lower.tail = FALSE)

# opcjonalnie: możemy też obliczyć chi kwadrat za pomoca funkcji CrossTable
CrossTable(x = usedcars$model, y = usedcars$conservative, chisq = TRUE)
